{block name='address_selector_blocks'}
  {foreach $addresses as $address}
    <article
      class="js-address-item address-item{if $address.id == $selected} selected{/if}"
      id="{$name|classname}-address-{$address.id}"
    >
      <header class="h4">
        <label class="radio-block">
          <span class="custom-radio">
            <input
              type="radio"
              name="{$name}"
              value="{$address.id}"
              {if $address.id == $selected}checked{/if}
            >
            <span></span>
          </span>
              {if $address.id_yb}
                <span class="address-alias h4"><img src="{$youbica_img|cat:'eyoubica-logo-color.svg'}" style="width: 100%;"/></span>
                <div class="address">Estás enviando este artículo a {$address.firstname|cat:' '|cat:$address.lastname nofilter} con e-youbica. ¡Enhorabuena por hacer feliz a otra persona!</div>
              {else}
                <span class="address-alias h4">{$address.alias}</span>
                <div class="address">{$address.formatted nofilter}</div>
              {/if}
        </label>
      </header>
      <hr>
      <footer class="address-footer">
        {if $interactive}
          {if !$address.id_yb}
            <a
              class="edit-address text-muted"
              data-link-action="edit-address"
              href="{url entity='order' params=['id_address' => $address.id, 'editAddress' => $type, 'token' => $token]}"
            >
              <i class="material-icons edit">&#xE254;</i>{l s='Edit' d='Shop.Theme.Actions'}
            </a>
          {/if}
          <a
            class="delete-address text-muted"
            data-link-action="delete-address"
            href="{url entity='order' params=['id_address' => $address.id, 'deleteAddress' => true, 'token' => $token]}"
          >
            <i class="material-icons delete">&#xE872;</i>{l s='Delete' d='Shop.Theme.Actions'}
          </a>
        {/if}
      </footer>
    </article>
  {/foreach}
  {if $interactive}
    <p>
      <button class="ps-hidden-by-js form-control-submit center-block" type="submit">{l s='Save' d='Shop.Theme.Actions'}</button>
    </p>
  {/if}
{/block}
