console.log("Youbica js file...");

function initYBLogin() {
    console.log("YB module ready for login...");
    $("#yb-modal-body").addClass('yb-login-body');

    $('#yb-login-form').submit(function (event) {
        event.preventDefault();
        let url = $(this).attr('action');
        const form = new FormData(event.target);
        let data = {
            email: form.get('email'),
            password: form.get('password')
        }

        $('#form-errors').html('');
        $('#btn-login').prop( "disabled", true );
        $.post(url, data, null).then((resp) => {
            $('#btn-login').prop( "disabled", false );
            $('#yb-modal-body').html(resp);
            initYBSearch();

        }).fail((resp) => {
            $('#btn-login').prop( "disabled", false );
            //prestashop.emit('handleError', {eventType: 'clickQuickView', resp: resp});
            //mostrar error
            let data = JSON.parse(resp.responseText)?.data;
            if(data) {
                let message = '';
                if(data.code == 422) {
                    message += `<ul class="mb-0">`;
                    Object.entries(data.data).forEach(([key, value]) => {                    
                        if( Array.isArray(value) ) {
                            value.forEach(_v => {
                                message += `<li>${_v}</li>`;
                            });
                        } else {
                            message += `<li>${value}</li>`;
                        }
                    });
                    message += `</ul>`;
                } else {
                    message = data.message;
                }
                $('#form-errors').html(`<div class="alert alert-danger" role="alert">${message}</div>`);
            }
        });
        
        return false;
    });
}

function initYBSearch() {
    console.log("YB module ready for search...");
    $("#yb-modal-body").removeClass('yb-login-body');

    $('#yb_logout').show();
    $('#yb_logout').click(function (event) {
        event.preventDefault();
        const url = $(this).attr('data-action');
        
        $.get(url).then((resp) => {
            $('#yb_logout').hide();
            $('#yb-modal-body').html(resp);
            initYBLogin();

        }).fail((resp) => {
            //prestashop.emit('handleError', {eventType: 'clickQuickView', resp: "nada"});
            console.log("ocurrio un error al cerrar sesion de e-youbica");
        });

        return false;
    });

    $("#yb-search").autocomplete({
        source:function(request,response){
            
            const data = {
                nombre: document.getElementById('yb-search').value
            };

            $('#search-errors').html(``);
            $.post(youbica.search_url, data, null, 'json').then((resp) => {
                var items = [];
                $.each( resp, function(key, val){
                    items.push({id: val.id, label: val.nombreUsuario});
                });

                console.log(items);
                response(items);
            }).fail((resp) => {
                let data = JSON.parse(resp.responseText)?.data;
                if(data) {
                    let message = '';
                    if(data.code == 422) {
                        message += `<ul class="mb-0">`;
                        Object.entries(data.data).forEach(([key, value]) => {                    
                            if( Array.isArray(value) ) {
                                value.forEach(_v => {
                                    message += `<li>${_v}</li>`;
                                });
                            } else {
                                message += `<li>${value}</li>`;
                            }
                        });
                        message += `</ul>`;
                    } else {
                        message = data.message;
                    }
                    $('#search-errors').html(`<div class="alert alert-danger" role="alert">${message}</div>`);
                }
                response(null);
            });
        },

        select: function(event, ui) {  
            $("#yb-modal-body .confirmar > #youbica-confirm > #user-id-youbica").val(ui.item.id);
            $("#yb-modal-body .confirmar > .added > span").html(ui.item.label);
            $("#yb-modal-body .confirmar").show();
        },
        search: function () {
          $("#yb-search-wrap").addClass("isloading");
        },
        response: function () {
            $("#yb-search-wrap").removeClass("isloading");
        }
    });

    $("#youbica-confirm").submit(function (event) {
        event.preventDefault();
        let url = $(this).attr('action');
        const form = new FormData(event.target);
        let data = {
            user_id_youbica: form.get('user_id_youbica')
        }
        $('#form-errors').html('');
        $('#btn-youbica-confirm').prop( "disabled", true );

        $.post(url, data, null).then((resp) => {
            $('#btn-youbica-confirm').prop( "disabled", false );
            //reload window
            document.location.reload();
        }).fail((resp) => {
            $('#btn-youbica-confirm').prop( "disabled", false );
            //prestashop.emit('handleError', {eventType: 'clickQuickView', resp: resp});
            //mostrar error
            let data = JSON.parse(resp.responseText)?.data;
            if(data) {
                let message = '';
                if(data.code == 422) {
                    message += `<ul class="mb-0">`;
                    Object.entries(data.data).forEach(([key, value]) => {                    
                        if( Array.isArray(value) ) {
                            value.forEach(_v => {
                                message += `<li>${_v}</li>`;
                            });
                        } else {
                            message += `<li>${value}</li>`;
                        }
                    });
                    message += `</ul>`;
                } else {
                    message = data.message;
                }
                $('#form-errors').html(`<div class="alert alert-danger" role="alert">${message}</div>`);
            }
        });

        return false;
    });

    $('#btn-youbica-copy').on('click', function(e) {
        console.log('copiando url registro');
        navigator.clipboard.writeText("https://e-youbica.com/register");
    });
}

$(document).ready(function(){
    if(youbica.has_session) initYBSearch();
    else initYBLogin();
});