<?php

require_once _PS_MODULE_DIR_ . 'youbica/.env.php';
require_once _PS_MODULE_DIR_ . 'youbica/classes/YbSession.php';

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

class YoubicaApiModuleFrontController extends ModuleFrontController
{
    public $ajax;
    public $client;
    
    public $base_url = YOUBICA_API_URL;
    public $ver = YOUBICA_API_VER;


    function __construct() {
        parent::__construct();
        $this->name = 'youbica';
        $this->client = new Client(['base_url' => [$this->base_url, ['version' => $this->ver]]]);
    }

    public function initContent()
    {
        //die("AJAX INIT CONTENT: ".Tools::getValue('action'));
        $this->ajax = true;
        
        // your code here
        switch(Tools::getValue('action')){
            case 'login': $this->actionLogin(); break;
            case 'logout': $this->actionLogout(); break;
            case 'search': $this->actionSearch(); break;
            case 'confirm': $this->actionConfirm(); break;
        }

        //$this->setTemplate('module:youbica/views/templates/hook/validation.tpl');
        //$this->display();
        parent::initContent();
        
    }

    public function actionLogin()
    {
        $data = [
            'correo' => Tools::getValue('email'),
            'password' => Tools::getValue('password')
        ];

        $shop_public_key = base64_encode(Configuration::get('YB_PUBLIC_KEY', null, null, 'PUBLIC_KEY'));

        try{
            $response = $this->client->post('auth/login', [
                'headers'=>[
                    'S-Authorization' => "Bearer $shop_public_key",
                    'Yb-Plugin' => 'PS'
                ],
                'body'=> $data
            ]);
        } catch ( RequestException $e ){
            http_response_code($e->getCode());
            $res = ['code' => $e->getCode(),'message' => $e->getMessage(),];
            if($e->hasResponse()){
                $body = json_decode((string) $e->getResponse()->getBody(true));
                $res['data'] = $body;
            }
            $this->ajaxRender( json_encode($res) );
            die();
        }

        $contents = json_decode($response->getBody()->getContents());
        // insertar session en la base de datos
        if ($this->context->customer->isLogged()) {
            $id_customer = $this->context->customer->id;
            $id_guest = 0;
        } else {
            $guest = new Guest($this->context->cart->id_guest);
            $id_customer = $guest->id_customer;
            $id_guest = $guest->id;
        }
        
        $_s = new YbSession();
            $_s->id_customer = $id_customer;
            $_s->id_guest = $id_guest;
            $_s->id_yb = $contents->user->id;
            $_s->username = $contents->user->nombreCuenta;
            $_s->name = $contents->user->nombreUsuario;
            $_s->token = $contents->token;
            $_s->active = true;
        if(!$_s->add()) {
            $res = ['code' => 422, 'message' => "No se pudo guardar la sesion en la base de datos."];
            $this->ajaxRender( json_encode($res) );
            die();
        }
        

        $this->context->smarty->assign($this->getWidgetVariables());
        $this->setTemplate('module:youbica/views/templates/hook/_partials/_search-alt.tpl');
        return ['data' => json_encode($this->display())];
    }

    public function actionLogout()
    {
        $_s = $this->getSession();

        if($_s) {
            try{
                if($_s->delete()){
                    //$this->clearAdsressesYB();

                    $this->context->smarty->assign($this->getWidgetVariables());
                    $this->setTemplate('module:youbica/views/templates/hook/_partials/_login.tpl');
                    return ['data' => json_encode($this->display())];
                }

                
            } catch (PrestaShopException $e) {
                $this->ajaxRender( json_encode($e));
                die();
            }
        }

        http_response_code(400);
        $res = [
            'code' => 400,
            'message' => "Error cerrando session!",
            'data' => ['message' => "Ocurrio un error al borrar la session de youbica."]
        ];
        $this->ajaxRender( json_encode($res));
        die();
    }

    public function actionSearch()
    {
        $shop_public_key = base64_encode(Configuration::get('YB_PUBLIC_KEY', null, null, 'PUBLIC_KEY'));
        $_s = $this->getSession();

        try{
            $response = $this->client->get('amigos?nombre='.Tools::getValue('nombre'), [
                'headers'=>[
                    'S-Authorization' => "Bearer $shop_public_key",
                    'Authorization' => "Bearer $_s->token",
                    'Yb-Plugin' => 'PS'
                ]
            ]);
        } catch ( RequestException $e ){
            http_response_code($e->getCode());
            $res = ['code' => $e->getCode(),'message' => $e->getMessage(),];
            if($e->hasResponse()){
                $body = json_decode((string) $e->getResponse()->getBody(true));
                $res['data'] = $body;
            }
            $this->ajaxRender( json_encode($res) );
            die();
        }

        $contents = json_decode($response->getBody()->getContents());
        $this->ajaxRender( json_encode($contents) );
    }

    public function actionConfirm()
    {
        // borrar direcciones anteriores que no se utilizaron
        $this->clearAdsressesYB();

        //die(json_encode($this->context));
        $shop_public_key = base64_encode(Configuration::get('YB_PUBLIC_KEY', null, null, 'PUBLIC_KEY'));
        $_s = $this->getSession();
        $user_id_youbica = Tools::getValue('user_id_youbica');

        try{
            $response = $this->client->get("amigo/$user_id_youbica", [
                'headers'=>[
                    'S-Authorization' => "Bearer $shop_public_key",
                    'Authorization' => "Bearer $_s->token",
                    'Yb-Plugin' => 'PS'
                ]
            ]);
        } catch ( RequestException $e ){
            http_response_code($e->getCode());
            $res = ['code' => $e->getCode(),'message' => $e->getMessage(),];
            if($e->hasResponse()){
                $body = json_decode((string) $e->getResponse()->getBody(true));
                $res['data'] = $body;
            }
            $this->ajaxRender( json_encode($res) );
            die();
        }

        $amigo = json_decode($response->getBody()->getContents());
        // crear address con info de persona a regalar
        $alias = "Amigo e-youbica";

        $id_country = null;
        $id_state = null;

        if(!empty($amigo->pais))
            $id_country = Country::getByIso( strtoupper($amigo->pais->code) );

        if(!$id_country) {
            http_response_code(400);
            $res = [
                'code' => 400,
                'message' => "Error creando direccion!",
                'data' => ['message' => "La direccion proporcionada no cuenta con un codigo de pais compatible con prestashop."]
            ];
            $this->ajaxRender( json_encode($res));
            die();
        }

        $country = new Country((int) $id_country);

        //solo intentar asignar estado si el pais lo requiere
        if( $country->contains_states && !empty($amigo->estado) ) {
            $id_state = State::getIdByIso( !empty($amigo->estado->code_alpha3)? strtoupper($amigo->estado->code_alpha3) : strtoupper($amigo->estado->code), $id_country );
            // si no lo encuentra por codigo intentar por nombre
            if(!$id_state) {
                $id_state = State::getIdByName( $amigo->estado->local_name );
                // ya si no lo encuentra por el nombre traducido ver si se puede el nombre en ingles
                if(!$id_state && ($amigo->estado->local_name != $amigo->estado->name) ) {
                    $id_state = State::getIdByName( $amigo->estado->name );
                }
            }
        }

        if( $country->contains_states && !$id_state ){
            http_response_code(400);
            $res = [
                'code' => 400,
                'message' => "Error creando direccion!",
                'data' => ['message' => "La direccion proporcionada por la persona a la que intentas regalar es incompatible con Prestashop."],
            ];
            $this->ajaxRender( json_encode($res));
            die();
        }

        if( !$amigo->nombre && !$amigo->apellido ){
            http_response_code(400);
            $res = [
                'code' => 400,
                'message' => "Error creando direccion!",
                'data' => ['message' => "El usuario de e-youbica al que intentas regalar no cuenta con nombre y/o apellido correcto."],
            ];
            $this->ajaxRender( json_encode($res));
            die();
        }

        $new_address = new Address();
            $new_address->id_country = $id_country;
            $new_address->id_state = $id_state;
            $new_address->id_customer = $_s->id_customer;
            $new_address->id_yb = $amigo->id;
            $new_address->alias = $alias;
            //$new_address->company = 'e-youbica';
            $new_address->lastname = $amigo->apellido;
            $new_address->firstname = $amigo->nombre;
            $new_address->address1 = $amigo->address1;
            $new_address->address2 = $amigo->coloniaMunicipio;
            $new_address->postcode = $amigo->codigoPostal;
            $new_address->city = $amigo->ciudad;
            $new_address->phone = $amigo->telefono;
            $new_address->dni = !empty($amigo->dni)? $amigo->dni : "1";
            $new_address->active = true;
            $new_address->deleted = false;

        try{
            $new_address->add();
            //die(json_encode($new_address));
        } catch (PrestaShopException $e) {
            $code = $e->getCode() ? $e->getCode() : 400;
            http_response_code($code);
            $res = [
                'code' => $code,
                'message' => $e->getMessage(),
                'data' => ['message' => "Error guardando direccion en Prestashop!"]
            ];
            $this->ajaxRender( json_encode($res) );
            die();
        }

        // cambiar estado de el carrito
        $cart = $this->context->cart;
        $cart->updateDeliveryAddressId($cart->id_address_delivery, $new_address->id);
        
        $this->ajaxRender( json_encode(['status' => "success"]));
        die();
    }

    public function clearAdsressesYB()
    {
        $addresses = $this->context->customer->getAddresses($this->context->language->id);
        foreach($addresses as $address){
            if(isset($address['id_yb']) && !empty($address['id_yb'])){
                $_a = new Address($address['id_address']);
                $_a->delete();
            }
        }
    }

    /** funciones copiadas de clase Youbica */
    public function getWidgetVariables($hookName = null, array $configuration = [])
    {
        $_s = $this->getSession();
        $shop_public_key = base64_encode(Configuration::get('YB_PUBLIC_KEY', null, null, 'PUBLIC_KEY'));
        $disabled = false;
        
        // verificar estado de subscripcion de empresa en youbica
        if(isset($configuration['store_status']) && $configuration['store_status']){
            try{
                $response = $this->client->get('empresa/info', [
                    'headers'=>[
                        'S-Authorization' => "Bearer $shop_public_key",
                        'Yb-Plugin' => 'PS'
                    ]
                ]);

                $contents = json_decode($response->getBody()->getContents());
                $disabled = !$contents->is_subscribed;
                if(isset($contents->disabled)) $disabled = $disabled && $contents->disabled;
            } catch ( RequestException $e ){
                $disabled = true;
            }
        }

        // cargar imagen de avartar actual de servidor de youbica si el usuario esta logueado
        $avatar = null;
        if($_s){
            try{
                $response = $this->client->get('usuario/'.$_s->id_yb, [
                    'headers'=>[
                        'S-Authorization' => "Bearer $shop_public_key",
                        'Yb-Plugin' => 'PS'
                    ]
                ]);

                $contents = json_decode($response->getBody()->getContents());
                $avatar = $contents->foto_perfil? $contents->foto_perfil : null;
            } catch ( RequestException $e ){}
        }

        return [
            'module' => $this->name,
            'disabled' => $disabled,
            'session' => $_s,
            'action_login' => Context::getContext()->link->getModuleLink($this->name, 'api', ['action'=> 'login']),
            'action_logout' => Context::getContext()->link->getModuleLink($this->name, 'api', ['action'=> 'logout']),
            'action_confirm' => Context::getContext()->link->getModuleLink($this->name, 'api', ['action'=> 'confirm']),
            'youbica_img' => $this->context->link->getMediaLink(_MODULE_DIR_.$this->name.'/views/img/'),
            'avatar' => $avatar,
        ];
    }

    public function getSession($active = true)
    {
    	$this->context = Context::getContext();

        if ($this->context->customer->isLogged()) {
            //echo $this->context->customer->id;
            return YbSession::findByCustomerID($this->context->customer->id);
        }
        return YbSession::findByGuestID($this->context->cart->id_guest);
    }
}