<?php

class YbSession extends ObjectModel
{
    public $id_session;
    public $id_customer;
    public $id_guest;
    public $id_yb;
    public $username;
    public $name;
    public $token;
    public $active;
    public $date_add;
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = [
        'table' => 'yb_session',
        'primary' => 'id_session',
        'fields' => [
            'id_customer' => ['type' => self::TYPE_INT, 'validate' => 'isunsignedInt', 'required' => false],
            'id_guest' => ['type' => self::TYPE_INT, 'validate' => 'isunsignedInt', 'required' => false],
            'id_yb' => ['type' => self::TYPE_INT, 'validate' => 'isunsignedInt', 'required' => true],
            'username' => ['type' => self::TYPE_STRING, 'validate' => 'isCleanHtml', 'size' => 255, 'required' => true],
            'name' => ['type' => self::TYPE_STRING, 'validate' => 'isCleanHtml', 'size' => 255, 'required' => true],
            'token' => ['type' => self::TYPE_STRING, 'validate' => 'isCleanHtml', 'size' => 255, 'required' => true],
            'active' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool', 'required' => true],
            'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
            'date_upd' => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
        ],
    ];

    public static function findByCustomerID($id_customer, $active = true) {
        $res = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
                SELECT * FROM '._DB_PREFIX_.self::$definition['table'].'
                WHERE `id_customer` = '. $id_customer .
                ($active ? ' AND `active` = 1' : ' ').'
                ORDER BY `date_add` DESC LIMIT 1'
            );

        if(sizeof($res)){
            $_s = new YbSession();
            foreach ($res[0] as $key => $value) {
                $_s->$key = $value;
            }
            return $_s;
        }

        return false;
    }

    public static function findByGuestID($id_guest, $active = true) {
        $res = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
                SELECT * FROM '._DB_PREFIX_.self::$definition['table'].'
                WHERE `id_guest` = '. $id_guest .
                ($active ? ' AND `active` = 1' : ' ').'
                ORDER BY `date_add` DESC LIMIT 1'
            );

        if(sizeof($res)){
            $_s = new YbSession();
            foreach ($res[0] as $key => $value) {
                $_s->$key = $value;
            }
            return $_s;
        }

        return false;
    }

    /**
     * Deletes current object from database.
     *
     * @return bool True if delete was successful
     *
     * @throws PrestaShopException
     */
    public function delete()
    {
        return $res = Db::getInstance(_PS_USE_SQL_SLAVE_)->execute("UPDATE `"._DB_PREFIX_.self::$definition['table']."` SET `active` = '0' WHERE (`id_session` = '$this->id_session')");
    }
}
