<?php

use Symfony\Component\Translation\TranslatorInterface;

class CheckoutPaymentStep extends CheckoutPaymentStepCore
{
    protected $template = 'modules/youbica/views/templates/override/checkout/_partials/steps/payment.tpl';
    private $selected_payment_option;

    /**
     * @param array $extraParams
     *
     * @return string
     */
    public function render(array $extraParams = [])
    {
        $isFree = 0 == (float) $this->getCheckoutSession()->getCart()->getOrderTotal(true, Cart::BOTH);
        $paymentOptions = $this->paymentOptionsFinder->present($isFree);
        $conditionsToApprove = $this->conditionsToApproveFinder->getConditionsToApproveForTemplate();
        $deliveryOptions = $this->getCheckoutSession()->getDeliveryOptions();
        $deliveryOptionKey = $this->getCheckoutSession()->getSelectedDeliveryOption();

        if (isset($deliveryOptions[$deliveryOptionKey])) {
            $selectedDeliveryOption = $deliveryOptions[$deliveryOptionKey];
        } else {
            $selectedDeliveryOption = 0;
        }
        unset($selectedDeliveryOption['product_list']);

        $addresses = $this->context->customer->getSimpleAddresses(null, false);
        foreach ($addresses as &$a) {
            $a['formatted'] = AddressFormat::generateAddress(new Address($a['id']), [], '<br>');
        }

        $assignedVars = [
            'is_free' => $isFree,
            'payment_options' => $paymentOptions,
            'conditions_to_approve' => $conditionsToApprove,
            'selected_payment_option' => $this->selected_payment_option,
            'selected_delivery_option' => $selectedDeliveryOption,
            'show_final_summary' => Configuration::get('PS_FINAL_SUMMARY_ENABLED'),
            'addresses' => $addresses,
            'youbica_img' => $this->context->link->getMediaLink(_MODULE_DIR_.'youbica/views/img/'),
        ];

        return $this->renderTemplate($this->getTemplate(), $extraParams, $assignedVars);
    }
}
