<?php

if (!defined('_PS_VERSION_')) exit;
require_once _PS_MODULE_DIR_ . 'youbica/.env.php';
require_once _PS_MODULE_DIR_ . 'youbica/classes/YbSession.php';

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

//include_once(_PS_MODULE_DIR_.'youbica/HomeLinkA.php');
class Youbica extends Module implements WidgetInterface
{
	protected $tn_session = 'yb_session';
	protected $_html = '';
	protected $templateFile;

    public $client;
    public $base_url = YOUBICA_API_URL;
    public $ver = YOUBICA_API_VER;

	public function __construct()
    {
        $this->name = 'youbica';
        $this->tab = 'social_networks';
        $this->version = '1.0.0';
        $this->author = 'VAGAPP';
        $this->need_instance = 0;
        $this->secure_key = Tools::hash($this->name);
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('e-youbica');
        $this->description = $this->l('Plugin to connect your Prestashop store to e-youbica\'s API to grant your cliets the posibility to send gifts to other e-youbica users.');
        $this->ps_versions_compliancy = ['min' => '1.7', 'max' => _PS_VERSION_];
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');

        $this->templateFile = 'module:youbica/views/templates/hook/block.tpl';

        $this->client = new Client(['base_url' => [$this->base_url, ['version' => $this->ver]]]);
    }

    /**
     * @see Module::install()
     */
    public function install() : bool
    {
        /* Adds Module */
        if (parent::install() &&
            Configuration::updateValue('YB_PUBLIC_KEY', '') &&
            Configuration::updateValue('YB_PRIVATE_KEY', '') &&
            Configuration::updateValue('YB_SHOW_BTN_ON_SUMMARY', true) &&
            $this->registerHook('displayYoubicaButtonRow') && // custom hook
            //$this->registerHook('displayCheckoutSummaryTop') && // hook que aparece arriba de los productos
            $this->registerHook('displayBeforeBodyClosingTag') &&
            $this->registerHook('displayOverrideTemplate') &&
            $this->registerHook('actionFrontControllerSetMedia') &&
            $this->registerHook('actionValidateOrder') && 
            $this->registerHook('actionPaymentConfirmation') &&
            $this->registerHook('displayAdminOrderSide') && $this->registerHook('displayAdminOrderTabShip')
        ) {
            /* Creates tables */
            $res = $this->createTables();

            /* Adds samples 
            if ($res) {
                $this->installSamples();
            }*/

            // Disable on mobiles and tablets
            //$this->disableDevice(Context::DEVICE_MOBILE);

            return (bool)$res;
        }

        return false;
    }

    /**
     * @see Module::uninstall()
     */
    public function uninstall(): bool
    {
        /* Deletes Module */
        if (
            Configuration::deleteByName('YB_PUBLIC_KEY') &&
            Configuration::deleteByName('YB_PRIVATE_KEY') &&
            Configuration::deleteByName('YB_SHOW_BTN_ON_SUMMARY') &&
            parent::uninstall()
        ) {
            /* Deletes tables */
            $res = $this->deleteTables();

            return (bool)$res;
        }

        return false;
    }

    /**
     * Creates tables
     */
    protected function createTables(): bool
    {
        $sql = [];
        /* Session */ 
        $sql[] = '
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->tn_session.'` (
			  `id_session` INT UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_customer` INT UNSIGNED NOT NULL DEFAULT \'0\',
              `id_guest` INT UNSIGNED NOT NULL DEFAULT \'0\',
              `id_yb` INT UNSIGNED NOT NULL,
              `username` varchar(255) NOT NULL,
              `name` varchar(255) NOT NULL,
              `token` varchar(255) NOT NULL,
              `active` tinyint NOT NULL DEFAULT \'1\',
              `date_add` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
              `date_upd` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
			  PRIMARY KEY (`id_session`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
        ';

        $r = Db::getInstance()->executeS('
            SELECT count(*) AS \'exist\'
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE table_name = "'._DB_PREFIX_.'address"
                AND table_schema = "'._DB_NAME_.'"
                AND column_name = "id_yb"
        ');

        if( sizeof($r) && (int)$r[0]['exist'] == 0 ) {
            $sql[] = '
                ALTER TABLE `'._DB_NAME_.'`.`'._DB_PREFIX_.'address` 
                ADD COLUMN `id_yb` INT UNSIGNED NULL DEFAULT \'0\' AFTER `id_warehouse`;
            ';
        }

        $result = true;

        foreach ($sql as $query) {
            $result = $result && (bool)Db::getInstance()->execute($query);
        }

        return $result;
    }

    /**
     * Adds samples
     */
    protected function installSamples(): void { }

    /**
     * deletes tables
     */
    protected function deleteTables(): bool
    {
        return Db::getInstance()->execute('
            DROP TABLE IF EXISTS `'._DB_PREFIX_.YbSession::$definition['table'].'`;
        ');
        return true;
    }

    /**
     * load dependencies
     */
    public function loadAsset()
    {   
        $this->context->controller->addCSS('modules/' . $this->name . 'views/css/back.css', 'all');
        $this->context->controller->addJS('modules/' . $this->name . 'views/js/back.js');
    }

    /**
     * @return string
     *
     * @throws PrestaShopException
     */
    public function getContent()
    {
        $this->_html .= $this->headerHTML();

        if (Tools::isSubmit('submitLink')) {
            if ($this->_postValidation()) {
                $this->_postProcess();
            }
            $this->_html .= $this->renderForm();

            $this->clearCache();
        } else {
            //render config form
            $this->_html .= $this->renderForm();
        }
        
        
        return $this->_html;
    }

    public function headerHTML()
    {
        if (Tools::getValue('controller') != 'AdminModules' && Tools::getValue('configure') != $this->name) {
            return;
        }

        $this->loadAsset();
        /* Style & js for fieldset 'links configuration' */
        $html = '<script type="text/javascript">
            $(function() {
                // add js lines
            });
        </script>';

        return $html;
    }

    public function renderForm()
    {
        $fields_form = [
            'form' => [
                'legend' => [
                    'title' => 'Configuracion',
                    'icon' => 'icon-cogs'
                ],
                'input' => [
                    [
                        'type' => 'textarea',
                        'label' => 'Public Key',
                        'name' => 'YB_PUBLIC_KEY',
                        'required' => true,
                        'lang' => false,
                        'rows' => 6
                    ],
                    [
                        'type' => 'textarea',
                        'label' => 'Private Key',
                        'name' => 'YB_PRIVATE_KEY',
                        'required' => true,
                        'lang' => false,
                        'rows' => 6
                    ],
                    [
                        'type' => 'switch',
                        'label' => 'Mostrar boton en resumen de compra',
                        'name' => 'YB_SHOW_BTN_ON_SUMMARY',
                        'is_bool' => true,
                        'values' => [
                            [
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->getTranslator()->trans('Yes', array(), 'Admin.Global')
                            ],
                            [
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->getTranslator()->trans('No', array(), 'Admin.Global')
                            ]
                        ],
                    ]
                ],
                'submit' => [
                    'title' => $this->getTranslator()->trans('Save', array(), 'Admin.Actions'),
                ]
            ],
        ];

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $this->fields_form = array();
        $helper->module = $this;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitLink';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'base_url' => $this->context->shop->getBaseURL(),
            'fields_value' => $this->getConfigValues(),
            'image_baseurl' => $this->_path.'images/'
        );

        $helper->override_folder = '/';

        return $helper->generateForm(array($fields_form));
    }

    public function getConfigValues()
    {
        $fields = array();

        $fields['YB_PUBLIC_KEY'] = Configuration::get('YB_PUBLIC_KEY');
        $fields['YB_PRIVATE_KEY'] = Configuration::get('YB_PRIVATE_KEY');
        $fields['YB_SHOW_BTN_ON_SUMMARY'] = Configuration::get('YB_SHOW_BTN_ON_SUMMARY');

        return $fields;
    }

    protected function _postValidation()
    {
        $errors = array();

        if (Tools::isSubmit('submitLink')) {
            // hacer validaciones y agregar errores
        }

        /* Display errors if needed */
        if (count($errors)) {
            $this->_html .= $this->displayError(implode('<br />', $errors));

            return false;
        }

        /* Returns if validation is ok */

        return true;
    }

    protected function _postProcess()
    {
        $errors = array();

        if (Tools::isSubmit('submitLink')) {
            Configuration::updateValue('YB_PUBLIC_KEY', Tools::getValue('YB_PUBLIC_KEY'));
            Configuration::updateValue('YB_PRIVATE_KEY', Tools::getValue('YB_PRIVATE_KEY'));
            Configuration::updateValue('YB_SHOW_BTN_ON_SUMMARY', Tools::getValue('YB_SHOW_BTN_ON_SUMMARY'));
        }

        /* Display errors if needed */
        if (count($errors)) {
            $this->_html .= $this->displayError(implode('<br />', $errors));
        }
    }

    public function clearCache()
    {
        $this->_clearCache($this->templateFile);
    }

    public function hookDisplayAdminOrderSide($params)
    {
        if($order = new Order($params['id_order'])) {
            $address = new Address($order->id_address_delivery);
            if(isset($address->id_yb) && !empty($address->id_yb)) {
                return $this->fetch('module:youbica/views/templates/admin/order-note.tpl');
            }
        }
    }

    /** pre 1.7.7 */
    public function hookDisplayAdminOrderTabShip($params)
    {
        if($order = new Order($params['id_order'])) {
            $address = new Address($order->id_address_delivery);
            if(isset($address->id_yb) && !empty($address->id_yb)) {
                return $this->fetch('module:youbica/views/templates/admin/order-note.tpl');
            }
        }
    }

    public function hookActionFrontControllerSetMedia($params)
    {
        $this->context->controller->registerStylesheet('bootstrap-float-label-css', 'modules/' . $this->name . '/views/css/bootstrap-float-label.css');
        $this->context->controller->registerStylesheet('yb-front-css', 'modules/' . $this->name . '/views/css/front.css');

        $_s = $this->getSession();
        Media::addJsDef([
            $this->name => [
                'has_session' => $_s? true: false,
                'search_url' => Context::getContext()->link->getModuleLink($this->name, 'api', ['action'=> 'search'])
            ]
        ]);
        $this->context->controller->registerJavascript('yb-front-js', 'modules/' . $this->name . '/views/js/front.js');
    }

    public function hookActionValidateOrder($params)
    {
        if($order = $params['order']) {
            $address = new Address($order->id_address_delivery);
            if(isset($address->id_yb) && !empty($address->id_yb)){
                // borrar address cargada con youbica al crear la orden
                try{
                    $address->delete();
                } catch(PrestaShopException $e) {}
            }
        }
    }

    public function hookActionPaymentConfirmation($params)
    {
        if($order = new Order($params['id_order'])) {
            $address = new Address($order->id_address_delivery);
            if(isset($address->id_yb) && !empty($address->id_yb)){
                $shop_public_key = base64_encode(Configuration::get('YB_PUBLIC_KEY', null, null, 'PUBLIC_KEY'));
                $_s = YbSession::findByCustomerID($order->id_customer, false);

                if($_s && $_s->id_yb) {
                    $desc = "<div class=\"ps-gift-desc\">";
                        $desc .= "<h4>REFERENCIA: $order->reference</h4>";

                        $desc .= "<ul>";
                        $items = $order->getCartProducts();
                        foreach($items as $item) {
                            $desc .= "<li>$item[product_name], X$item[product_quantity]</li>";
                        }
                        $desc .= "</ul>";
                    $desc .= "</div>";

                    $data = [
                        'destinatario_id' => $address->id_yb,
                        'remitente_id' => $_s->id_yb,
                        'tienda' => Configuration::get('PS_SHOP_NAME'),
                        'nombre' => Configuration::get('PS_SHOP_NAME'),
                        'url' => Context::getContext()->link->getBaseLink(),
                        'descripcion' => $desc,
                    ];
                    
                    try{
                        $response = $this->client->post('regalos', [
                            'headers'=>[
                                'S-Authorization' => "Bearer $shop_public_key"
                            ],
                            'body'=> $data
                        ]);
                    } catch ( RequestException $e ){
                        //$this->displayError("Ocurrio un error al notificar a e-youbica de envio de regalo.");
                    }
                }
            }
        }
    }

    public function hookDisplayOverrideTemplate($param)
    {
        $template_file = $param['template_file'];

        // when I see that FrontController is trying to load 'customer/order-detail' I modify the behavior:
        if ($template_file === 'customer/order-detail') {
            $this->context->smarty->assign([
                'youbica_img' => $this->context->link->getMediaLink(_MODULE_DIR_.$this->name.'/views/img/'),
            ]);
            return 'module:youbica/views/templates/override/customer/order-detail.tpl';
        }

         // else I do nothing
         return false;
    }

    /**
     * front hooks and functions
    */

    public function hookDisplayBeforeBodyClosingTag($params)
    {   
        // if current page is checkout include modal code on footer
        if( $this->context->controller->php_self === 'order' ) {

            $vars = $this->getWidgetVariables();
            $template = $vars['session']? 'search.tpl': 'login.tpl';
            
            $this->smarty->assign($vars);
            return $this->display(__FILE__, 'views/templates/hook/_partials/'.$template);
        }
    }

    public function renderWidget($hookName = null, array $configuration = [])
    {
        $configuration['store_status'] = true;

        if (!$this->isCached($this->templateFile, $this->getCacheId())) {
            $this->smarty->assign($this->getWidgetVariables($hookName, $configuration));
        }

        //if ($this->context->customer->isLogged()) {
            return $this->fetch($this->templateFile, $this->getCacheId());
        //}
    }

    public function getWidgetVariables($hookName = null, array $configuration = [])
    {
        $_s = $this->getSession();
        $shop_public_key = base64_encode(Configuration::get('YB_PUBLIC_KEY', null, null, 'PUBLIC_KEY'));
        $disabled = false;
        
        // verificar estado de subscripcion de empresa en youbica
        if(isset($configuration['store_status']) && $configuration['store_status']){
            try{
                $response = $this->client->get('empresa/info', [
                    'headers'=>[
                        'S-Authorization' => "Bearer $shop_public_key"
                    ]
                ]);

                $contents = json_decode($response->getBody()->getContents());
                $disabled = !$contents->is_subscribed;
                if(isset($contents->disabled)) $disabled = $disabled && $contents->disabled;
            } catch ( RequestException $e ){
                $disabled = true;
            }
        }

        // cargar imagen de avartar actual de servidor de youbica si el usuario esta logueado
        $avatar = null;
        if($_s){
            try{
                $response = $this->client->get('usuario/'.$_s->id_yb, [
                    'headers'=>[
                        'S-Authorization' => "Bearer $shop_public_key"
                    ]
                ]);

                $contents = json_decode($response->getBody()->getContents());
                $avatar = $contents->foto_perfil? $contents->foto_perfil : null;
            } catch ( RequestException $e ){}
        }

        return [
            'module' => $this->name,
            'disabled' => $disabled,
            'session' => $_s,
            'action_login' => Context::getContext()->link->getModuleLink($this->name, 'api', ['action'=> 'login']),
            'action_logout' => Context::getContext()->link->getModuleLink($this->name, 'api', ['action'=> 'logout']),
            'action_confirm' => Context::getContext()->link->getModuleLink($this->name, 'api', ['action'=> 'confirm']),
            'youbica_img' => $this->context->link->getMediaLink(_MODULE_DIR_.$this->name.'/views/img/'),
            'avatar' => $avatar,
        ];
    }

    public function getSession($active = true)
    {
    	$this->context = Context::getContext();

        if ($this->context->customer->isLogged()) {
            //echo $this->context->customer->id;
            return YbSession::findByCustomerID($this->context->customer->id);
        }
        return YbSession::findByGuestID($this->context->cart->id_guest);
    }
}