<?php

class Address extends AddressCore
{
    /** @var int State ID */
    public $id_yb;

    /** Adds required $defitinion fields */
    public function __construct($id_address = null, $id_lang = null)
    {
        self::$definition['fields']['id_yb'] = ['type' => self::TYPE_INT, 'validate' => 'isNullOrUnsignedId'];
        parent::__construct($id_address, $id_lang);
    }

    public static function getFirstCustomerAddressId($id_customer, $active = true)
    {
        if (!$id_customer) {
            return false;
        }
        $cache_id = 'Address::getFirstCustomerAddressId_' . (int) $id_customer . '-' . (bool) $active;
        if (!Cache::isStored($cache_id)) {
            $result = (int) Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue(
                '
				SELECT `id_address`
				FROM `' . _DB_PREFIX_ . 'address`
				WHERE `id_customer` = ' . (int) $id_customer . ' AND `id_yb` = 0 AND `deleted` = 0' . ($active ? ' AND `active` = 1' : '')
            );
            Cache::store($cache_id, $result);

            return $result;
        }

        return Cache::retrieve($cache_id);
    }
}