<?php


defined( 'ABSPATH' ) || exit;
final class Youbica { 
	public $version = '1.0.3'; 
	protected static $_instance = null; 

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

    /**
	 * e-youbica Constructor.
	 */
    function __construct() {
        $this->init_hooks();
    }
    
	private function init_hooks() {
		add_action('admin_init', array($this, 'initSettings'));
        add_action('admin_menu', array($this, 'settignsLink'));
 
		add_action('woocommerce_before_checkout_form', array($this, 'LoginYoubica'));
		add_action( 'woocommerce_email_customer_details', array( $this, 'youbica_email_addresses' ), 21, 3 );

		add_action('wp_enqueue_scripts',  array($this, 'initScript'));
    }

	function initSettings() {
		add_settings_section('ybp_api_keys_section', null, null, 'youbica-settings-page');

		add_settings_field('ybp_public_key', 'Public Key', array($this, 'textareaHTML'), 'youbica-settings-page', 'ybp_api_keys_section', array('name'=>'ybp_public_key', 'type'=>'text'));
		register_setting('youbicaplugin','ybp_public_key', array('sanitize_callback' => 'sanitize_textarea_field', 'default' => null));

		add_settings_field('ybp_private_key', 'Private Key', array($this, 'textareaHTML'), 'youbica-settings-page', 'ybp_api_keys_section', array('name'=>'ybp_private_key', 'type'=>'password'));
		register_setting('youbicaplugin', 'ybp_private_key', array('sanitize_callback' => 'sanitize_textarea_field', 'default' => null)); 
	}

	function initScript(){
		wp_enqueue_script( 'js-youbica', plugins_url(null, YOUBICA_PLUGIN_FILE).'/assets/js/youbica.js', ['jquery', 'jquery-ui-core', 'jquery-ui-autocomplete'], null, true);

		// init user vars
		$id_user = isset($_COOKIE['id_user_youbica'])? sanitize_key($_COOKIE['id_user_youbica']) : null;
		$token_user = isset($_COOKIE['token_user_youbica'])? sanitize_textarea_field($_COOKIE['token_user_youbica']) : null;

		if (!empty($token_user)) { 
            wp_localize_script( 'js-youbica', 'user_id', array('current_user' => esc_js($id_user),'base_url' => get_site_url(), 'token' => esc_js($token_user)));
        } else {
            wp_localize_script( 'js-youbica', 'user_id', array('current_user' => 0, 'base_url' => get_site_url(), 'token' => ''));
        }
		 
		wp_enqueue_style( 'css-youbica', plugins_url(null, YOUBICA_PLUGIN_FILE) . '/assets/css/youbica.css');
		wp_enqueue_style( 'css-youbicad', plugins_url(null, YOUBICA_PLUGIN_FILE) . '/assets/css/jquery-ui.css');
	}

    function settignsLink() {
        add_options_page(
            'Youbica Settings',
            'e-youbica',
            'manage_options',
            'youbica-settings-page',
            array($this, 'settingsPageHTML')
        );
    }
    
    function settingsPageHTML() { ?>
        <div class="wrap">
            <h1>Ajustes e-youbica</h1>

			<?php if(YOUBICA_ENV !== 'live') { ?>
			<div class="notice notice-warning settings-error"> 
				<p><strong>e-youbica se encuentra actualmente en entorno <?php echo esc_html(strtoupper(YOUBICA_ENV)) ?>.</strong></p>
			</div>
			<?php } ?>

			<form action="options.php" method="POST" autocomplete="off">
			<?php
				settings_fields('youbicaplugin');
				do_settings_sections('youbica-settings-page');
				submit_button();
			?>
			</form>
        </div>
    <?php }

	function inputHTML($args) { ?>
		<input type="<?php echo esc_attr($args['type']) ?>" class="regular-text" name="<?php echo esc_attr($args['name']) ?>" value="<?php echo esc_textarea(get_option($args['name'])) ?>" autocomplete="off">
	<?php }

	function textareaHTML($args) { ?>
		<textarea class="large-text code" name="<?php echo esc_attr($args['name']) ?>" rows="6" autocomplete="off"><?php echo esc_textarea(get_option($args['name'])) ?></textarea>
	<?php }

	function LoginYoubica($user) {
		// init user vars
		$user_token_youbica = isset($_COOKIE['token_user_youbica'])? sanitize_textarea_field($_COOKIE['token_user_youbica']) : null;
		$name_user_youbica = isset($_COOKIE['name_user_youbica'])? sanitize_user($_COOKIE['name_user_youbica']) : null;
		$avatar_user_youbica = isset($_COOKIE['avatar_user_youbica'])? sanitize_url($_COOKIE['avatar_user_youbica']) : null;

		?>
		<button class="modal-toggle">Regala con e-youbica</button>
			<div class="modal_youbica"> 
				<div class="modal-wrapper modal-transition"> 
					<div class="modal-body">
						<div class="modal-header">  
						<?php if(!empty($user_token_youbica)){ ?>
							<button class="btn-logout">Cerrar sesión</button>
						<?php }  ?>   
							<button class="modal-close modal-toggle">
							<img alt="e-Youbica logo" src="<?php echo esc_url(plugin_dir_url( __DIR__ )."assets/img/close.png"); ?>" style="height: 15px;"> 
							</button> 
						</div> 
						<div class="modal-content">
							<img alt="e-Youbica logo" src="<?php echo esc_url(plugin_dir_url( __DIR__ )."assets/img/logo-color.svg"); ?>" class="logo"> 
						 
							<?php if(empty($user_token_youbica)){ ?>
							<div class="login">
								<form id="loginYoubica" method="POST">
									<div class="email">  
										<input type="email"  name="email" id="email" placeholder="Correo electrónico o usuario e-youbica"> 
									</div>
									<div class="password"> 
										<input type="password"  name="password" id="password" placeholder="Contraseña">
									</div>
									<div class="submit">
										<input type="submit" value="INGRESAR">
										<a href="https://e-youbica.com/register" target="_blank" class="btn-youbica">CREAR CUENTA</a>
										<a href="https://e-youbica.com/lost-password" target="_blank">¿Olvidaste tu contraseña?</a>
									</div>
								</form> 
							</div> 
							<?php } else { ?>
							<div class="content">
								<div class="header"> 
									<?php if(!empty($avatar_user_youbica)){
									?>
										<div class="avatar">
											<img alt="e-Youbica logo" src="<?php echo esc_url($avatar_user_youbica) ?>">
										</div>
									<?php
									} ?>
									 
									<h3>Has ingresado como: @<?php echo esc_html($name_user_youbica); ?> </h3> 
								</div>
								<p>Ya estás listo para regalar. Busca a la persona a la que deseas hacerle un regalo sopresa.</p>
								<div class="buscador">
									<div class="ui-widget"> 
										<div class="form-row"> 
											<div class="loading" id="loading1" style="float:right"></div> 
											<input id="tags" type="text" name="youbica_friend" class="input-text"> 
										</div>
									</div>
									<button class="confirm-youbica modal-toggle btn-youbica-confirm">
										CONFIRMAR
									</button> 
								</div> 
								
								<div class="invitar">
									<h3>¿La persona que buscas no está en e-youbica?</h3>
									<h4>Inivitala/o a unirse</h4>
									<input type="text" value="https://e-youbica.com/register">
									<button class="btn-youbica-copy">Copiar</button>
									<div class="clear" style="clear:both;"></div>
								</div> 
							</div>
							<?php }  ?>
						</div>
					</div> 
				</div>
			</div> 
	<?php } 

	function ybButtonRowHTML($user) {
		if(is_user_logged_in()){
			$user_token_youbica = get_the_author_meta( 'token_user_youbica', $user->ID ); 
		} else {
			//init user vars
			$user_token_youbica = isset($_COOKIE['token_user_youbica'])? sanitize_textarea_field($_COOKIE['token_user_youbica']) : null;
		}

		if(empty($user_token_youbica) ){  
		} else {  ?>
		<div class="wrap-collabsible yb-checkout-btn-row ">
			<input id="collapsible" class="toggle" type="checkbox">
			<label for="collapsible" class="lbl-toggle button alt yb-checkout-btn" style="display:block;">Regala con e-youbica</label>
			<div class="collapsible-content">
				<div class="content-inner">
				 
				</div>
			</div>
		</div>
		<hr>
		<?php }
	}

	/**
	 * Get the email addresses.
	 *
	 * @param WC_Order $order         Order instance.
	 * @param bool     $sent_to_admin If should sent to admin.
	 * @param bool     $plain_text    If is plain text email.
	 */
	public function youbica_email_addresses( $order, $sent_to_admin = false, $plain_text = false ) {

		if ( ! is_a( $order, 'WC_Order' ) ) {
			return;
		}

		if($sent_to_admin && get_post_meta($order->id, '_yuobica_gift', true )){
			$text_align = is_rtl() ? 'right' : 'left';
			$raw_address = array(
				'first_name' => get_post_meta($order->id, '_yuobica_shipping_first_name', true ),
				'last_name'  => get_post_meta($order->id, '_yuobica_shipping_last_name', true ),
				'company'    => '',
				'address_1'  => get_post_meta($order->id, '_yuobica_shipping_address_1', true ),
				'address_2'  => '',
				'city'       => get_post_meta($order->id, '_yuobica_shipping_city', true ),
				'state'      => get_post_meta($order->id, '_yuobica_shipping_state', true ),
				'postcode'   => get_post_meta($order->id, '_yuobica_shipping_postcode', true ),
				'country'    => get_post_meta($order->id, '_yuobica_shipping_country', true )
			);
			$address        = WC()->countries->get_formatted_address( $raw_address );
			$shipping_phone = get_post_meta($order->id, '_yuobica_shipping_phone', true );
			$shipping_email = get_post_meta($order->id, '_yuobica_shipping_email', true );

			if ( $plain_text ) {
				echo "\n" . esc_html( wc_strtoupper( esc_html__( 'Shipping address', 'woocommerce' ) ) ) . " e-youbica\n\n";
				echo preg_replace( '#<br\s*/?>#i', "\n", $address ) . "\n"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

				if ( $shipping_phone ) {
					echo $shipping_phone . "\n"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				}

				if ( $shipping_email ) {
					echo $shipping_email . "\n"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				}
			} else { ?>
				<table id="addresses" cellspacing="0" cellpadding="0" style="width: 100%; vertical-align: top; margin-bottom: 40px; padding:0;" border="0">
					<tr>
						<td style="text-align:<?php echo esc_attr( $text_align ); ?>; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border:0; padding:0;" valign="top" width="50%">
							<h2><?php esc_html_e( 'Shipping address', 'woocommerce' ); ?> e-youbica</h2>
				
							<address class="address">
								<?php echo wp_kses_post( $address ? $address : esc_html__( 'N/A', 'woocommerce' ) ); ?>
								<?php if ( $shipping_phone ) : ?>
									<br/><?php echo wc_make_phone_clickable( $shipping_phone ); ?>
								<?php endif; ?>
								<?php if ( $shipping_email ) : ?>
									<br/><?php echo esc_html( $shipping_email ); ?>
								<?php endif; ?>
							</address>
							<p style="margin-top: 5px; color: red;">Recuerda proporcionar estos datos a la paquetería, no compartas esta información con el usuario de la compra.</p>
						</td>
					</tr>
				</table>
			<?php }
		}

		
	}
}